/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.repl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.repl.EvalManager;
import com.probejs.repl.Evaluator;

public enum REPLCommand {
    EVALUATE,
    GET_PACKS,
    GET_GLOBALS;


    public static JsonElement process(Payload payload) {
        return switch (payload.command) {
            default -> throw new IncompatibleClassChangeError();
            case EVALUATE -> REPLCommand.evaluate(payload.payload);
            case GET_PACKS -> REPLCommand.getPacks(payload.payload);
            case GET_GLOBALS -> REPLCommand.getGlobals(payload.payload);
        };
    }

    private static EvalManager getManager(String type) {
        return switch (type) {
            case "startup_scripts" -> EvalManager.STARTUP_SCRIPTS;
            case "client_scripts" -> EvalManager.CLIENT_SCRIPTS;
            case "server_scripts" -> EvalManager.SERVER_SCRIPTS;
            default -> throw new RuntimeException("Unknown script manager %s.".formatted(type));
        };
    }

    public static JsonElement evaluate(JsonObject payload) {
        String type = payload.get("type").getAsString();
        String pack = payload.get("pack").getAsString();
        String input = payload.get("input").getAsString();
        EvalManager manager = REPLCommand.getManager(type);
        Evaluator evaluator = manager.getEvaluator(pack);
        return EvalManager.jsToJson(evaluator.getContext(), evaluator.evaluate(input));
    }

    public static JsonElement getPacks(JsonObject payload) {
        String type = payload.get("type").getAsString();
        return EvalManager.jsToJson(null, REPLCommand.getManager(type).getScriptPacks());
    }

    public static JsonElement getGlobals(JsonObject payload) {
        String type = payload.get("type").getAsString();
        String pack = payload.get("pack").getAsString();
        return EvalManager.jsToJson(null, REPLCommand.getManager(type).getEvaluator(pack).getTopLevelVariables());
    }

    public static class Payload {
        public String id;
        public REPLCommand command;
        public JsonObject payload;
    }
}

